/*
 * TagInfoEntry.cpp
 *
 *  Created on: 23.10.2009
 *      Author: stefan.detter
 */

#include "InfoEntry.h"

#include "TagEntry.h"

InfoEntry::InfoEntry(TreeItem* parent, QString key, QVariant value)
	: TreeItem(parent)
	, m_key(key)
	, m_value(value)
	, m_type(VALUE)
{
}

InfoEntry::InfoEntry(TreeItem* parent, QString key, QVariant value, int min, int max, QString text)
	: TreeItem(parent)
	, m_key(key)
	, m_value(value)
	, m_type(PROGRESSBAR)
	, m_progressBarMin(min)
	, m_progressBarMax(max)
	, m_progressBarText(text)
{
}

InfoEntry::~InfoEntry()
{
    emit aboutToBeRemoved(this);
}


void InfoEntry::setDecorator(QString path)
{
    m_decorator = path;
}


QString InfoEntry::key() const
{
	return m_key;
}

QVariant InfoEntry::value() const
{
	return m_value;
}

void InfoEntry::setValue(QVariant value)
{
	m_value = value;
}

bool InfoEntry::hasChild(QString key)
{
	return m_childInfos.contains(key);
}

void InfoEntry::addChild(QString key, QVariant value)
{
	if(!m_childInfos.contains(key))
	{
		emit beginInsertRows( this, m_children.size(), m_children.size());

		InfoEntry* i = new InfoEntry(this, key, value);

		connectChild(i);

		m_children.append(i);
		m_childInfos.insert(key, i);
		emit endInsertRows();
	}
}

void InfoEntry::addChild(QString key, QVariant value, int min, int max, QString text )
{
	if(!m_childInfos.contains(key))
	{
		emit beginInsertRows( this, m_children.size(), m_children.size());

		InfoEntry* i = new InfoEntry(this, key, value, min, max, text);

		connectChild(i);

		m_children.append(i);
		m_childInfos.insert(key, i);
		emit endInsertRows();
	}
}

void InfoEntry::setChildValue(QString key, QVariant value)
{
	if(m_childInfos.contains(key))
		m_childInfos.value(key)->setValue(value);
}

void InfoEntry::removeChild ( QString key )
{
	if(!m_childInfos.contains(key))
		return;

	TreeItem* t = m_childInfos.value(key);

	emit aboutToBeRemoved(t);

	emit beginRemoveRows( this, m_children.indexOf(t), m_children.indexOf(t) );
	m_children.removeAt(m_children.indexOf(t));
	m_childInfos.remove(key);
	emit endRemoveRows();

	delete t;

}

void InfoEntry::removeAllChildren ( )
{
	foreach(QString key, m_childInfos.keys())
	{
		removeChild(key);
	}
}
